local COLORS_FROM_PALETTE = {52, 53, 54, 55, 101}
local COOLDOWN = 60000
local DURATION = 15000
local COLOR_CHANGE_TIME = 80

function main(self)
	local claw = GetClaw()

	if self.State == 0 then
		self.Flags.AlwaysActive, self.DrawFlags.NoDraw = true, true
		self.cooldown = 0
		local isMultiPlayer = GetGameType() == GameType.MultiPlayer
		self.detector = GetObject(3206)
		local width = self.detector.ScreenW
		self.hud = CreateHUDObject{
			X = width - 23,
			Y = isMultiPlayer and 72 or 98,
			Z = 10050,
			Logic = "AniCycle",
			Image = "CUSTOM_INTERFACE_AG",
			Animation = "GAME_CYCLE200"
		}
		self.hudNumber1 = CreateHUDObject{
			X = width - 39,
			Y = isMultiPlayer and 73 or 99,
			Z = 10051,
			Logic = "DoNothing",
			Image = "CUSTOM_INTERFACE_SMALLNUMBERS"
		}
		self.hudNumber2 = CreateHUDObject{
			X = width - 31,
			Y = isMultiPlayer and 73 or 99,
			Z = 10051,
			Logic = "DoNothing",
			Image = "CUSTOM_INTERFACE_SMALLNUMBERS"
		}
		self.State = 1
	end

	-- Handle interface:
	if self.State >= 1 and self.State <= 6 then
		local cooldown = math.floor((self.cooldown-GetTime())/1000)
		if self.State == 1 then
			self.hudNumber1:SetFrame(1)
			self.hudNumber2:SetFrame(5)
		elseif self.State == 2 then
			self.hudNumber1:SetFrame(math.floor((cooldown-45)/10))
			self.hudNumber2:SetFrame((cooldown-45)%10)
        else
            self.hudNumber1:SetFrame(math.floor(cooldown/10))
			self.hudNumber2:SetFrame(cooldown%10)
		end
	end

	-- Activate:
	if self.State == 1 and GetInput"Special" then
		self.cooldown = GetTime() + COOLDOWN
		self.timeCounter = GetTime() + DURATION
		self.emptySoundDelay = GetTime() + 2000
		if _CurrentPowerup[0] == Powerup.Vader then
			ClawGivePowerup(Powerup.Vader, 15)
			self.State = 4
		else
			SetImgFlag(claw.Image, ImageFlag.Shadow)
			self.vaderColor = COLORS_FROM_PALETTE[1]
			self.vaderColorIndex = 1
			self.vaderColorChangeTime = GetTime() + COLOR_CHANGE_TIME
			self.State = 2
		end
	end
    
    -- Active:
    if self.State == 2 then
		if GetTime() >= self.timeCounter or claw.Health <= 0 then
            self.State = 3
        end

		if _CurrentPowerup[0] == Powerup.Vader then
			return
		end

		if GetTime() > self.vaderColorChangeTime then
			SetImgColor(claw.Image, self.vaderColor)
			self.vaderColorChangeTime = GetTime() + COLOR_CHANGE_TIME
			self.vaderColorIndex = self.vaderColorIndex + 1
			if self.vaderColorIndex > #COLORS_FROM_PALETTE then
				self.vaderColorIndex = 1
			end
			self.vaderColor = COLORS_FROM_PALETTE[self.vaderColorIndex]
		end

		if claw.HitTypeFlags ~= 11863296 then
	        claw.HitTypeFlags = 11863296
		end
    end
    
	-- Deactivate:
	if self.State == 3 then
		if _CurrentPowerup[0] ~= Powerup.Vader then
			if claw.HitTypeFlags == 11863296 then
				claw.HitTypeFlags = 28640580
			end
			SetImgFlag(claw.Image, ImageFlag.Normal)
		end
		self.State = 4
	end
    
    -- Cooldown:
	if self.State == 4 then
        if GetInput"Special" and GetTime() > self.emptySoundDelay then
            self.emptySoundDelay = GetTime() + 2000
            PlaySound("CLAW_EMPTYMAGIC")
		end
        if GetTime() > self.cooldown then
		    self.State = 1
        end
	end
end
